
#include "Perus.h"





void AlustaOGLjaSDL( unsigned short Leveys, unsigned short Korkeus, int VideoTilanLiput, char *Nimi )
{
    AlustaSDL( Leveys, Korkeus, VideoTilanLiput, Nimi );
    
    AlustaOpenGL( Leveys, Korkeus );
    
    glewInit();
}

void AlustaSDL( unsigned short Leveys, unsigned short Korkeus, int VideoTilanLiput, char *Nimi)
{
    //const SDL_VideoInfo* VideoInfo = SDL_GetVideoInfo( );
    SDL_Init(SDL_INIT_VIDEO);
    SDL_SetVideoMode(Leveys, Korkeus, 0, VideoTilanLiput);
    SDL_WM_SetCaption(Nimi, "");
    SDL_ShowCursor( 0 );
    SDL_WM_GrabInput(SDL_GRAB_ON);

    SDL_Init(SDL_INIT_AUDIO);

    int AudioRate = 22050;
    Uint16 AudioFormat = AUDIO_S16SYS;
    int AudioChannels = 2;
    int AudioBuffers = 4096;
 
    Mix_OpenAudio( AudioRate, AudioFormat, AudioChannels, AudioBuffers );
    Mix_AllocateChannels( 100 );
}


void AlustaOpenGL(unsigned short Leveys, unsigned short Korkeus)
{
    glViewport(0, 0, Leveys, Korkeus);
	//glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LEQUAL);
	glClearDepth(1000.0f);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glEnable(GL_CULL_FACE);
    
    glMatrixMode(GL_PROJECTION);
    gluPerspective(70, (double)Leveys/Korkeus, 1, 1000);
    glMatrixMode(GL_MODELVIEW);

    glEnable(GL_TEXTURE_2D);
    
    glEnableClientState( GL_VERTEX_ARRAY );
	glEnableClientState( GL_TEXTURE_COORD_ARRAY );
    
    //glEnable(GL_ALPHA_TEST);
    //glAlphaFunc(GL_GREATER, 0.1);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
}



long Sattuma(long Pienin, long Suurin)
{
    return (rand()%(Suurin-Pienin+1)) + Pienin;
}






char *LukuSanaksi(double Luku, int Desimaaleja)
{
    char Puskuri[1024];
    int Numeroita;


    for(int i= -1; i< 20; i++)
    {
        if((Luku <= -pow((double)10, i) && Luku > -pow((double)10, i+1))
        || (Luku >= pow((double)10, i)) && (Luku < pow((double)10, i+1)))
        { 
            Numeroita = i+1 + Desimaaleja; 
            break;
        }
    }

    return gcvt((double)Luku, Numeroita, Puskuri);
}

char* LukuSanaksi(long Luku)
{
    char Puskuri[512];
    return  ltoa((long)Luku, Puskuri, 10);
}



char Akanoi(char *&Sana)
{
    bool SananLopussa = true;
    for(int i = strlen(Sana)-1; i > -1; i--)
    {
        if(iscntrl(Sana[i]))
        {
            if(SananLopussa){ Sana[i] = 0; }
            if(!SananLopussa){ Sana[i] = ' '; }
        }else
        {
            SananLopussa = false;
        }
        
    }
    
}

char PyyhiLoppu(char *&Sana, char Merkki)
{
    bool Poista = false;
    for(int i = 0; i < strlen(Sana); i++)
    {
        if(Sana[i] == Merkki) Poista = true;
        if(Poista) Sana[i] = 0;
    }
}
char PyyhiAlkuJaLoppu(char *&Sana, char Merkki)
{
    bool Poista = true;
    for(int i = 0; i < strlen(Sana); i++)
    {
        if(Poista) Sana[i] = 0;
        if(Sana[i] == Merkki) Poista = false;
    }


    Poista = false;
    for(int i = 0; i < strlen(Sana); i++)
    {
        if(Sana[i] == Merkki) Poista = true;
        if(Poista) Sana[i] = 0;
    }
}
char PyyhiAlkuJaLoppu( char *&Sana, char AlkuMerkki, char LoppuMerkki)
{
    bool Poista = true;
    for(int i = 0; i < strlen(Sana); i++)
    {
        if(Poista) Sana[i] = 0;
        if(Sana[i] == AlkuMerkki) Poista = false;
    }


    Poista = false;
    for(int i = 0; i < strlen(Sana); i++)
    {
        if(Sana[i] == LoppuMerkki) Poista = true;
        if(Poista) Sana[i] = 0;
    }
}






















